<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<div class="container py-5" style="background: linear-gradient(135deg, #87CEEB 0%, #4169E1 100%); min-height: 100vh;">
    <div class="row">
        <div class="col-12">
            <!-- Header Section -->
            <div class="text-center mb-5">
                <div class="d-inline-flex align-items-center justify-content-center bg-white rounded-circle shadow-lg mb-4" style="width: 80px; height: 80px;">
                    <i class="bi bi-award text-primary" style="font-size: 2.5rem;"></i>
                </div>
                <h1 class="display-4 fw-bold text-white mb-3">Sertifikat</h1>
                <p class="lead text-white opacity-90">Koleksi sertifikat dan pencapaian profesional</p>
            </div></div>
    <!-- Search and Filter Section -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card shadow-lg border-0" style="background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px);">
                <div class="card-header bg-transparent border-0 py-4">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0 text-primary">
                            <i class="bi bi-funnel me-2"></i>Pencarian & Filter
                        </h4>
                        <div class="text-primary">
                            <i class="bi bi-collection me-1"></i>
                            Total: <strong><?= $total ?></strong> sertifikat
                        </div>
                    </div>
                </div>
                
                <div class="card-body">
                    <form method="GET" action="<?= base_url('certificates') ?>" class="row g-3">
                        <div class="col-md-4">
                            <label for="search" class="form-label text-primary fw-semibold">
                                <i class="bi bi-search me-2"></i>Cari Sertifikat
                            </label>
                            <div class="input-group">
                                <input type="text" class="form-control border-primary" id="search" name="search" 
                                       value="<?= esc($search) ?>" placeholder="Nama sertifikat, penerbit, atau deskripsi...">
                                <button class="btn btn-outline-primary" type="button" onclick="document.getElementById('search').value=''; this.form.submit();">
                                    <i class="bi bi-x"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <label for="penerbit" class="form-label text-primary fw-semibold">
                                <i class="bi bi-building me-2"></i>Penerbit
                            </label>
                            <input type="text" class="form-control border-primary" id="penerbit" name="penerbit" 
                                   value="<?= esc($filter['penerbit']) ?>" placeholder="Filter penerbit...">
                        </div>
                        <div class="col-md-2">
                            <label for="tanggal_dari" class="form-label text-primary fw-semibold">
                                <i class="bi bi-calendar me-2"></i>Dari Tanggal
                            </label>
                            <input type="date" class="form-control border-primary" id="tanggal_dari" name="tanggal_dari" 
                                   value="<?= esc($filter['tanggal_dari']) ?>">
                        </div>
                        <div class="col-md-2">
                            <label for="tanggal_sampai" class="form-label text-primary fw-semibold">
                                <i class="bi bi-calendar-check me-2"></i>Sampai Tanggal
                            </label>
                            <input type="date" class="form-control border-primary" id="tanggal_sampai" name="tanggal_sampai" 
                                   value="<?= esc($filter['tanggal_sampai']) ?>">
                        </div>
                        <div class="col-md-1">
                            <label for="sort" class="form-label text-primary fw-semibold">
                                <i class="bi bi-sort me-2"></i>Urutkan
                            </label>
                            <select class="form-select border-primary" id="sort" name="sort">
                                <option value="tanggal_terbit" <?= $sort === 'tanggal_terbit' ? 'selected' : '' ?>>Tanggal</option>
                                <option value="nama_sertifikat" <?= $sort === 'nama_sertifikat' ? 'selected' : '' ?>>Nama</option>
                                <option value="penerbit" <?= $sort === 'penerbit' ? 'selected' : '' ?>>Penerbit</option>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <label for="order" class="form-label text-primary fw-semibold">
                                <i class="bi bi-arrow-up-down me-2"></i>Arah
                            </label>
                            <select class="form-select border-primary" id="order" name="order">
                                <option value="DESC" <?= $order === 'DESC' ? 'selected' : '' ?>>Terbaru</option>
                                <option value="ASC" <?= $order === 'ASC' ? 'selected' : '' ?>>Terlama</option>
                            </select>
                        </div>
                        <div class="col-12 d-flex gap-2 align-items-end">
                            <button type="submit" class="btn btn-primary px-4">
                                <i class="bi bi-search me-1"></i>Cari & Filter
                            </button>
                            <a href="<?= base_url('certificates') ?>" class="btn btn-outline-primary px-4">
                                <i class="bi bi-arrow-clockwise me-1"></i>Atur Ulang
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Certificates List -->
    <?php if (empty($certificates)): ?>
        <div class="row">
            <div class="col-12">
                <div class="card shadow-lg border-0 text-center py-5" style="background: rgba(255, 255, 255, 0.95);">
                    <div class="card-body">
                        <i class="bi bi-info-circle text-primary mb-3" style="font-size: 3rem;"></i>
                        <h4 class="text-primary">Tidak ada sertifikat yang ditemukan</h4>
                        <p class="text-muted">Belum ada data sertifikat yang tersedia.</p>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="row g-4">
            <?php foreach ($certificates as $cert): ?>
                <div class="col-lg-4 col-md-6">
                    <div class="card h-100 shadow-lg border-0 certificate-card" style="background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); transition: transform 0.3s ease;">
                        <?php if ($cert['foto_sertifikat']): ?>
                            <?= clickable_image(image_url('certificates', $cert['foto_sertifikat'], 400, 250), esc($cert['nama_sertifikat']), 'card-img-top', 'height: 200px; object-fit: cover;') ?>
                        <?php else: ?>
                            <div class="card-img-top d-flex align-items-center justify-content-center bg-light" style="height: 200px;">
                                <i class="bi bi-award text-primary" style="font-size: 3rem;"></i>
                            </div>
                        <?php endif; ?>
                        <div class="card-body d-flex flex-column">
                            <h5 class="card-title text-primary fw-bold mb-3"><?= esc($cert['nama_sertifikat']) ?></h5>
                            <?php if ($cert['penerbit']): ?>
                                <p class="text-muted mb-2">
                                    <i class="bi bi-building me-1 text-primary"></i><?= esc($cert['penerbit']) ?>
                                </p>
                            <?php endif; ?>
                            <?php if ($cert['tanggal_terbit']): ?>
                                <p class="text-muted mb-2">
                                    <i class="bi bi-calendar me-1 text-primary"></i>
                                    <?= date('d F Y', strtotime($cert['tanggal_terbit'])) ?>
                                </p>
                            <?php endif; ?>
                            <?php if ($cert['nomor_sertifikat']): ?>
                                <p class="text-muted mb-2 small">
                                    <i class="bi bi-hash me-1 text-primary"></i>No: <?= esc($cert['nomor_sertifikat']) ?>
                                </p>
                            <?php endif; ?>
                            <?php if ($cert['deskripsi']): ?>
                                <p class="text-muted small flex-grow-1"><?= esc(substr($cert['deskripsi'], 0, 100)) ?><?= strlen($cert['deskripsi']) > 100 ? '...' : '' ?></p>
                            <?php endif; ?>
                            <?php if ($cert['link_sertifikat']): ?>
                                <a href="<?= esc($cert['link_sertifikat']) ?>" target="_blank" class="btn btn-primary w-100 mt-auto">
                                    <i class="bi bi-link-45deg me-1"></i>Lihat Sertifikat
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <!-- Enhanced Pagination -->
        <?php if (isset($lastPage) && $lastPage > 1): ?>
            <div class="row mt-5">
                <div class="col-12">
                    <nav aria-label="Page navigation">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="pagination-info">
                                <small class="text-white">
                                    Menampilkan <?= (($currentPage - 1) * 5) + 1 ?> - <?= min($currentPage * 5, $total) ?> dari <?= $total ?> sertifikat
                                </small>
                            </div>
                            <div class="pagination-summary">
                                <small class="text-white">
                                    Halaman <?= $currentPage ?> dari <?= $lastPage ?>
                                </small>
                            </div>
                        </div>
                        
                        <ul class="pagination justify-content-center">
                            <!-- First Page -->
                            <?php if ($currentPage > 2): ?>
                                <li class="page-item">
                                    <a class="page-link" href="<?= base_url('certificates?page=1&search=' . urlencode($search) . '&penerbit=' . urlencode($filter['penerbit']) . '&tanggal_dari=' . urlencode($filter['tanggal_dari']) . '&tanggal_sampai=' . urlencode($filter['tanggal_sampai']) . '&sort=' . $sort . '&order=' . $order) ?>" title="Halaman Pertama">
                                        <i class="bi bi-chevron-double-left"></i>
                                    </a>
                                </li>
                            <?php endif; ?>
                            
                            <!-- Previous Page -->
                            <?php if ($currentPage > 1): ?>
                                <li class="page-item">
                                    <a class="page-link" href="<?= base_url('certificates?page=' . ($currentPage - 1) . '&search=' . urlencode($search) . '&penerbit=' . urlencode($filter['penerbit']) . '&tanggal_dari=' . urlencode($filter['tanggal_dari']) . '&tanggal_sampai=' . urlencode($filter['tanggal_sampai']) . '&sort=' . $sort . '&order=' . $order) ?>" title="Halaman Sebelumnya">
                                        <i class="bi bi-chevron-left"></i> Sebelumnya
                                    </a>
                                </li>
                            <?php endif; ?>
                            
                            <!-- Page Numbers -->
                            <?php 
                            $startPage = max(1, $currentPage - 2);
                            $endPage = min($lastPage, $currentPage + 2);
                            
                            for ($i = $startPage; $i <= $endPage; $i++): ?>
                                <li class="page-item <?= $i == $currentPage ? 'active' : '' ?>">
                                    <a class="page-link" href="<?= base_url('certificates?page=' . $i . '&search=' . urlencode($search) . '&penerbit=' . urlencode($filter['penerbit']) . '&tanggal_dari=' . urlencode($filter['tanggal_dari']) . '&tanggal_sampai=' . urlencode($filter['tanggal_sampai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                        <?= $i ?>
                                    </a>
                                </li>
                            <?php endfor; ?>
                            
                            <!-- Next Page -->
                            <?php if ($currentPage < $lastPage): ?>
                                <li class="page-item">
                                    <a class="page-link" href="<?= base_url('certificates?page=' . ($currentPage + 1) . '&search=' . urlencode($search) . '&penerbit=' . urlencode($filter['penerbit']) . '&tanggal_dari=' . urlencode($filter['tanggal_dari']) . '&tanggal_sampai=' . urlencode($filter['tanggal_sampai']) . '&sort=' . $sort . '&order=' . $order) ?>" title="Halaman Selanjutnya">
                                        Selanjutnya <i class="bi bi-chevron-right"></i>
                                    </a>
                                </li>
                            <?php endif; ?>
                            
                            <!-- Last Page -->
                            <?php if ($currentPage < $lastPage - 1): ?>
                                <li class="page-item">
                                    <a class="page-link" href="<?= base_url('certificates?page=' . $lastPage . '&search=' . urlencode($search) . '&penerbit=' . urlencode($filter['penerbit']) . '&tanggal_dari=' . urlencode($filter['tanggal_dari']) . '&tanggal_sampai=' . urlencode($filter['tanggal_sampai']) . '&sort=' . $sort . '&order=' . $order) ?>" title="Halaman Terakhir">
                                        <i class="bi bi-chevron-double-right"></i>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                        
                        <!-- Quick Jump -->
                        <?php if ($lastPage > 5): ?>
                            <div class="text-center mt-3">
                                <form method="GET" action="<?= base_url('certificates') ?>" class="d-inline-flex align-items-center">
                                    <input type="hidden" name="search" value="<?= esc($search) ?>">
                                    <input type="hidden" name="penerbit" value="<?= esc($filter['penerbit']) ?>">
                                    <input type="hidden" name="tanggal_dari" value="<?= esc($filter['tanggal_dari']) ?>">
                                    <input type="hidden" name="tanggal_sampai" value="<?= esc($filter['tanggal_sampai']) ?>">
                                    <input type="hidden" name="sort" value="<?= esc($sort) ?>">
                                    <input type="hidden" name="order" value="<?= esc($order) ?>">
                                    <small class="text-white me-2">Lompat ke halaman:</small>
                                    <input type="number" name="page" min="1" max="<?= $lastPage ?>" value="<?= $currentPage ?>" 
                                           class="form-control form-control-sm" style="width: 80px;" onchange="this.form.submit()">
                                </form>
                            </div>
                        <?php endif; ?>
                    </nav>
                </div>
            </div>
        <?php endif; ?>
    <?php endif; ?>
</div>
</div>
<?= $this->endSection() ?>

